*******************************************************************************
*                         680xx Grundprogramm boot                            *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                                 Bootmen                                    *
*******************************************************************************


autoboot:
 lea nvrbuff(a5), a0
 cmp #$a5c3, (a0)               * NVRAM Daten?
 bne.s autob01                  * nein
 move.b 3(a0), bootdel(a5)      * Boot Delayzeit
 adda.l #4, a0                  * auf Autoboot Daten
 bra.s autob02
autob01:
 lea boottab(pc), a0            * Boot-Reihenfolge-Tabelle
autob02:
 move #4-1, d3                  * 4 Eintrge in der Tabelle
autob03:
 move.b (a0)+, d0               *
 bsr aboot
 bcc.b autobex                  * Boot war erfolgreich
 dbra d3, autob03
autobex:
 rts

aboot:
 cmp.b #3, d0
 bhi.s aboot01
 moveq #1,d4                    * Ein Bit
 lsl d0,d4                      * An die richtige Stelle schieben
 bsr floboot                    * Floppy
 bra.s abootex
aboot01:
 cmp.b #4, d0
 bhi.s aboot02
 bsr abtdel
 bsr scsiboot                   * SCSI-Disk
 bra.s abootex
aboot02:
 cmp.b #5, d0
 bhi.s aboot03
 bsr abtdel
 bsr ideboot1                   * IDE-Disk
 bra.s abootex
aboot03:
 cmp.b #6, d0
 bhi carset
 bsr sdboot                     * SD-Card
abootex:
 rts

abtdel:                         * Bootdelay, warten auf Laufwerk
 move.b bootdel(a5), d3
 beq.s abtdelx                  * Bootdelay 0 = Fertig
 lea abtdtxt0(pc),a0            * Bootdelay Text
 bsr headaclr
 lea abtdtxt1(pc), a0
 moveq #$33, d0
 move #40, d1
 move #120, d2
 bsr textaus
 lea abtdtxt2(pc), a0
 moveq #$33, d0
 move #202, d1
 move #120, d2
 bsr textaus

 move.b d3, d0
 divu #10, d0                   * /10 auf Sekunden
 and.l #$1f, d0
 lea ausbuf(a5), a0
 bsr print4d
 lea ausbuf(a5), a0
 move.b #$33, d0
 move #148, d1
 move #120, d2
 bsr textaus

 clr.l d0
 move.b d3, d0
 bsr delay                      * warten
 
 clr.b bootdel(a5)              * Nur einmal warten!
abtdelx:
 rts

boottab:                        * wird nur verwendet, wenn kein NVRAM da
 dc.b 0, 4, 5, 3                * Bootreihenfolge: Floppy1, SCSI, IDE, SRAMDISK

boot:                           * Boot-Men
 tst.b flo2srd(a5)              * Floppy4 nach SRAMDISK aktiv?
 beq.b boota                    * nein
 lea menue34a(pc),a0
 bra.b bootb
boota:
 lea menue34(pc),a0
bootb:
 bsr menueio
 sub.b  #'1',d0
 cmp.b  #3,d0
 bhi.s hardboot                 * 0-3 ist Floppy-Boot
 moveq #1,d4                    * Ein Bit
 lsl d0,d4                      * An die richtige Stelle schieben

floboot:                        * Diskette booten in d4 steht Laufwerk
 bsr getflop                    * Floppy Format feststellen
 bcs.s floboot1                 * Fehler oder keine Floppy geladen
 lea $1800(a5),a0               * Hinter Eprom laden
 moveq #1,d1
 moveq #1,d2
 moveq #0,d3
 bsr floppy                     * Spur 0, Sektor 1 lesen
 bcs.s floboot1
 moveq #0,d0                    * Kennung, da FLOPPY BOOT
 cmp #$4e71,(a0)                * Erster Befehl mu NOP sein fr BOOT Kennung
 bne.s floboot1                 * Fehler
floboot0:
 move.b menflag(a5),-(a7)       * menflag merken
 and.b #%01111011,menflag(a5)   * Kein Grundprogramm mehr
 jsr (a0)                       * Programm aufrufen
 bsr seta5                      * a5 zur Sicherheit auf alten Wert
 move.b (a7)+,menflag(a5)       * menflag zurck
bra carres                      * Boot wurde durchgefhrt
floboot1:
 move.b #$60,flo4.w             * Floppy-Motoren aus
bra carset                      * Boot wurde nicht ausgefhrt

hardboot:
 cmp.b  #4,d0                   * SCSI Disk-Boot
 bne.s  ideboot

scsiboot:
 clr.b scsi2ide(a5)             * SCSI nach IDE Umleitung loeschen
 moveq #1,d4                    * Harddisk 0
 bsr hardtest                   * Testen, ob vorhanden
 bcs carset                     * Nicht vorhanden
 cmp #2,d0
 beq.s scsiboot                 * Warte, bis Laufwerk richtig luft
 cmp #4,d0
 beq.s scsiboot                 * Warte, bis Laufwerk bereit
 lea $1800(a5),a0               * Zieladresse fr Daten
 clr (a0)                       * Sicherheitshalber
 moveq #1,d1                    * Sektor lesen
 moveq #0,d2                    * Sektor 0 lesen
 moveq #1,d3                    * Einen Sektor lesen
 bsr harddisk                   * Keine Fehlerabfrage, da zu aufwendig
 cmp #$4e71,(a0)
 bne carset                     * Fehler
 moveq #1,d0                    * Kennung fr SCSI-BOOT
bra.s floboot0

ideboot:
 cmp.b #5,d0                    * IDE Disk-Boot
 beq ideboot1
 bra.s sdboot

ideboot1:
 clr.b scsi2ide(a5)             * erstmal lschen
 moveq #1, d4                   * IDE Master Laufwerk
 bsr idetest                    * Testen, ob vorhanden
 bcs carset                     * IDE Disk nicht vorhanden
 lea $1800(a5),a0               * Zieladresse fr Daten
 clr (a0)                       * Sicherheitshalber
 moveq #1,d1                    * Sektor lesen
 moveq #0,d2                    * Sektor 0 lesen
 moveq #1,d3                    * Einen Sektor lesen
 bsr idedisk                    * Keine Fehlerabfrage, da zu aufwendig
 cmp #$4e71,(a0)                * NOP = NDR Boot?
 bne.s ideboota                 * nein
 lea $1a00(a5),a0               * Zieladresse fr 2.Sektor
 moveq #1, d2                   * Sektor 1 lesen
 bsr idedisk
 move.b #1, scsi2ide(a5)        * SCSI nach IDE Umleitung setzen
 moveq #1,d0                    * Kennung fr "SCSI"-BOOT
 lea $1800(a5),a0               * hier beginnt der Bootsektor
 bra.s idebootb
ideboota:
 cmp.w #$4e71, 4(a0)            * NOP als 3. Wort?
 bne carset                     * nein, dann nichts weiter tun
 moveq #2,d0                    * Kennung fr IDE-BOOT
idebootb:
 move.b menflag(a5),-(a7)       * menflag merken
 and.b #%01111011,menflag(a5)   * Kein Grundprogramm mehr
 jsr (a0)                       * Programm aufrufen
 bsr seta5                      * a5 zur Sicherheit auf alten Wert
 move.b (a7)+,menflag(a5)       * menflag zurck
 clr.b scsi2ide(a5)             * SCSI nach IDE Umleitung loeschen
bra carres                      * Boot wurde durchgefhrt

sdboot:
 cmp.b #6,d0                    * SD-Card Boot
 beq.s sdboot1
 bra carset

sdboot1:
 clr.b scsi2ide(a5)             * erstmal lschen
 moveq #1, d4                   * 1. SD Laufwerk
 bsr sdtest                     * Testen, ob vorhanden
 bcs carset                     * SD-Card nicht vorhanden
 lea $1800(a5),a0               * Zieladresse fr Daten
 clr (a0)                       * Sicherheitshalber
 moveq #1,d1                    * Sektor lesen
 moveq #0,d2                    * Sektor 0 lesen
 moveq #1,d3                    * Einen Sektor lesen
 bsr sddisk                     * Keine Fehlerabfrage, da zu aufwndig
 cmp #$4e71,(a0)                * NOP = NDR Boot?
 bne.s sdboota                  * nein
 lea $1a00(a5),a0               * Zieladresse fr 2.Sektor
 moveq #1, d2                   * Sektor 1 lesen
 bsr sddisk
 move.b #2, scsi2ide(a5)        * SCSI nach SD Umleitung setzen
 moveq #1,d0                    * Kennung fr "SCSI"-BOOT
 lea $1800(a5),a0               * hier beginnt der Bootsektor
 bra.s sdbootb
sdboota:
 cmp.w #$4e71, 4(a0)            * NOP als 3. Wort?
 bne carset                     * nein, dann nichts weiter tun
 moveq #3,d0                    * Kennung fr SD-BOOT
sdbootb:
 move.b menflag(a5),-(a7)       * menflag merken
 and.b #%01111011,menflag(a5)   * Kein Grundprogramm mehr
 jsr (a0)                       * Programm aufrufen
 bsr seta5                      * a5 zur Sicherheit auf alten Wert
 move.b (a7)+,menflag(a5)       * menflag zurck
 clr.b scsi2ide(a5)             * SCSI nach SD Umleitung lschen
bra carres                      * Boot wurde durchgefhrt


                                                                                                                                                                                                                                                                                                                                                       119
 dc.l asserr                    * Befehl 120
 dc.l tnotimp                   * Befehl 121    Nur beim 68020
 dc.l tnotimp                   * Befehl 122    Nur beim 68020
 dc.l readaus                   * Befehl 123
 dc.l grund                     * Befehl 124
 dc.l hardcopy                  * Befehl 125
 dc.l grafik                    * Befehl 126
 dc.l gdpvers                   * Befehl 127
 dc.l seraus                    * Befehl 128
 dc.l serex                     * Befehl 129
 dc.l clut